<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N.'); ?></th>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Designation'); ?></th>
                                    <th><?php echo app('translator')->get('Email'); ?></th>
                                    <th><?php echo app('translator')->get('Mobile'); ?></th>
                                    <th><?php echo app('translator')->get('Branch'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <?php if(can('admin.branch.staff.details') || can('admin.branch.staff.status')): ?>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $staffs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->index + $staffs->firstItem()); ?></td>

                                        <td><?php echo e($staff->name); ?></td>

                                        <td>
                                            <?php if($staff->designation): ?>
                                                <?php $branch = implode(', ', $staff->assignBranch->pluck('name')->toArray());?>

                                                <span class="fw-bold text--primary" title="<?php echo e($branch); ?>"><?php echo app('translator')->get('Manager'); ?></span>
                                            <?php else: ?>
                                                <span class="fw-bold text--info"><?php echo app('translator')->get('Account Officer'); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <td><?php echo e($staff->email); ?></td>

                                        <td><?php echo e($staff->mobile); ?></td>
                                        <td>
                                            <?php if(@$staff->branch()): ?>
                                            <?php echo e(@$staff->branch()->name); ?>

                                                <?php else: ?>
                                             <?php echo app('translator')->get('N/A'); ?>
                                            <?php endif; ?>
                                        </td>

                                        <td><?php echo $staff->statusBadge;?></td>
                                        <?php if(can('admin.branch.staff.details') || can('admin.branch.staff.status')): ?>
                                            <td>
                                                <div class="button--group">
                                                    <?php $hasPermission = App\Models\Role::hasPermission('admin.branch.staff.details')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                                        <a class="btn btn-sm btn-outline--primary" data-resource="<?php echo e($staff); ?>" href="<?php echo e(route('admin.branch.staff.details', $staff->id)); ?>">
                                                            <i class="la la-desktop"></i><?php echo app('translator')->get('Details'); ?>
                                                        </a>
                                                    <?php endif ?>
                                                    <?php $hasPermission = App\Models\Role::hasPermission('admin.branch.staff.status')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                                        <?php if($staff->status): ?>
                                                            <button class="btn btn-sm confirmationBtn btn-outline--danger" data-action="<?php echo e(route('admin.branch.staff.status', $staff->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to ban this staff?'); ?>" type="button">
                                                                <i class="las la-user-alt-slash"></i><?php echo app('translator')->get('Ban'); ?>
                                                            </button>
                                                        <?php else: ?>
                                                            <button class="btn btn-sm confirmationBtn btn-outline--success" data-action="<?php echo e(route('admin.branch.staff.status', $staff->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to unban this staff?'); ?>" type="button">
                                                                <i class="las la-user-check"></i><?php echo app('translator')->get('Unban'); ?>
                                                            </button>
                                                        <?php endif; ?>
                                                    <?php endif ?>
                                                </div>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($staffs->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($staffs)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <div class="btn-group">
        <button class="btn btn-outline--primary dropdown-toggle" data-bs-toggle="dropdown" type="button">
            <?php if(request()->branch): ?>
                <?php $branch = $branches->where('name', request()->branch)->first(); ?>
                <?php echo e(@$branch->name); ?>

            <?php else: ?>
                <?php echo app('translator')->get('All Branch'); ?>
            <?php endif; ?>
        </button>

        <ul class="dropdown-menu">
            <li>
                <a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['branch' => null])); ?>"><?php echo app('translator')->get('All Branch'); ?></a>
            </li>
            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['branch' => $branch->name])); ?>"><?php echo e(__($branch->name)); ?></a></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <div class="btn-group">
        <button class="btn btn-outline--primary dropdown-toggle" data-bs-toggle="dropdown" type="button">
            <?php if(request()->designation == 'manager'): ?>
                <?php echo app('translator')->get('Manager'); ?>
            <?php elseif(request()->designation == 'account_officer'): ?>
                <?php echo app('translator')->get('Account Officer'); ?>
            <?php else: ?>
                <?php echo app('translator')->get('All Staff'); ?>
            <?php endif; ?>
        </button>

        <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['designation' => null])); ?>"><?php echo app('translator')->get('All'); ?></a></li>
            <li><a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['designation' => 'manager'])); ?>"><?php echo app('translator')->get('Manager'); ?></a></li>
            <li><a class="dropdown-item" href="<?php echo e(request()->fullUrlWithQuery(['designation' => 'account_officer'])); ?>"><?php echo app('translator')->get('Account Officer'); ?></a></li>
        </ul>
    </div>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Email, Mobile']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Email, Mobile']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

    <?php $hasPermission = App\Models\Role::hasPermission('admin.branch.staff.add')  ? 1 : 0;
            if($hasPermission == 1): ?>
        <a class="btn btn-outline--primary h-45 ms-2" href="<?php echo e(route('admin.branch.staff.add')); ?>">
            <i class="la la-plus"></i><?php echo app('translator')->get('Add New'); ?>
        </a>
    <?php endif ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sorrowbank\core\resources\views/admin/branch_staff/index.blade.php ENDPATH**/ ?>