<?php $__env->startSection('main-content'); ?>
    <?php
        $policyPages = getContent('policy_pages.element', false, null, true);
        $signupBg = getContent('signup_bg.content', true);
    ?>

    <section class="account-section registration-section bg_img" style="background-image: url(' <?php echo e(getImage('assets/images/frontend/signup_bg/' . @$signupBg->data_values->image, '1920x1280')); ?>');">
        <div class="account-section-left">
            <div class="account-section-left-inner d-none d-sm-block">
                <h4 class="title text-white mb-2"><?php echo e(__(@$signupBg->data_values->heading)); ?></h4>
                <p class="text-white"><?php echo e(__(@$signupBg->data_values->subheading)); ?></p>
                <a href="<?php echo e(route('home')); ?>" class="btn btn-sm btn-outline--base mt-3"> <i class="la la-reply" aria-hidden="true"></i> <?php echo app('translator')->get('Back to Home'); ?></a>
            </div>
        </div>
        <div class="account-section-right">
            <div class="top text-center mb-5">
                <a href="<?php echo e(route('home')); ?>" class="account-logo">
                    <img src="<?php echo e(getImage('assets/images/logoIcon/logo.png')); ?>" alt="logo">
                </a>
            </div>
            <div class="middle">
                <form action="<?php echo e(route('user.register')); ?>" method="POST" class="verify-gcaptcha account-form">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <?php if(session()->get('reference') != null && $general->modules->referral_system): ?>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="referenceBy" class="form-label label"><?php echo app('translator')->get('Referred by'); ?></label>
                                    <input type="text" name="referBy" id="referenceBy" class="form--control" value="<?php echo e(session()->get('reference')); ?>" readonly>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label required"><?php echo app('translator')->get('Username'); ?></label>
                                <input type="text" class="form--control checkUser" name="username" value="<?php echo e(old('username')); ?>" required>
                                <small class="text-danger usernameExist"></small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label required"><?php echo app('translator')->get('E-Mail Address'); ?></label>
                                <input type="email" class="form--control checkUser" name="email" value="<?php echo e(old('email')); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label required"><?php echo app('translator')->get('Country'); ?></label>
                                <select name="country" class="form--control">
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-mobile_code="<?php echo e($country->dial_code); ?>" value="<?php echo e($country->country); ?>" data-code="<?php echo e($key); ?>">
                                            <?php echo e(__($country->country)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label required"><?php echo app('translator')->get('Mobile'); ?></label>
                                <div class="input-group ">
                                    <span class="input-group-text mobile-code text-white"></span>
                                    <input type="number" name="mobile" value="<?php echo e(old('mobile')); ?>" class="form--control checkUser" required>
                                </div>
                                <small class="text-danger mobileExist"></small>
                            </div>
                            <input type="hidden" name="mobile_code">
                            <input type="hidden" name="country_code">
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label required"><?php echo app('translator')->get('Password'); ?></label>
                                <input type="password" class="form--control <?php if($general->secure_password): ?> secure-password <?php endif; ?>" name="password" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label required"><?php echo app('translator')->get('Confirm Password'); ?></label>
                                <input type="password" class="form--control" name="password_confirmation" required>
                            </div>
                        </div>
                        <?php if (isset($component)) { $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243 = $component; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Captcha::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243)): ?>
<?php $component = $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243; ?>
<?php unset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243); ?>
<?php endif; ?>
                    </div>
                    <?php if($general->agree): ?>
                        <div class="form-group">
                            <input type="checkbox" id="agree" <?php if(old('agree')): echo 'checked'; endif; ?> name="agree" required>
                            <label for="agree"><?php echo app('translator')->get('I agree with'); ?></label>
                            <span>
                                <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('policy.pages', [slug($policy->data_values->title), $policy->id])); ?>" target="_blank"><?php echo e(__($policy->data_values->title)); ?></a>
                                    <?php if(!$loop->last): ?>
                                        ,
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </span>
                        </div>
                    <?php endif; ?>

                    <button type="submit" id="recaptcha" class="btn btn--base w-100"> <?php echo app('translator')->get('Register'); ?></button>

                </form>

                <p class="mt-3 text-white"><?php echo app('translator')->get('Already haver an account?'); ?>
                    <a href="<?php echo e(route('user.login')); ?>" class="text--base"><?php echo app('translator')->get('Login Now'); ?></a>
                </p>
            </div>
        </div>
    </section>

    <div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle"><?php echo app('translator')->get('You are with us'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <h6 class="text-center"><?php echo app('translator')->get('You already have an account please Login '); ?></h6>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn-sm" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    <a href="<?php echo e(route('user.login')); ?>" class="btn btn--base btn-sm"><?php echo app('translator')->get('Login'); ?></a>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php if($general->secure_password): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });

            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));

            <?php if($mobileCode): ?>
                $(`option[data-code=<?php echo e($mobileCode); ?>]`).attr('selected', '');
            <?php endif; ?>

            $('.checkUser').on('focusout', function(e) {

                var url = '<?php echo e(route('user.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';

                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {
                        mobile: mobile,
                        _token: token
                    };
                }

                if ($(this).attr('name') == 'email') {
                    var data = {
                        email: value,
                        _token: token
                    }
                }

                if ($(this).attr('name') == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }

                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`This ${response.type} is already exist`);
                    } else {
                        $(`.${response.type}Exist`).empty();
                    }
                });
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .country-code .input-group-text {
            background: #fff !important;
        }

        .country-code select {
            border: none;
        }

        .country-code select:focus {
            border: none;
            outline: none;
        }

        .input-popup {
            bottom: 80% !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/user/auth/register.blade.php ENDPATH**/ ?>