<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N.'); ?></th>
                                    <th><?php echo app('translator')->get('Bank'); ?></th>
                                    <th><?php echo app('translator')->get('Transfer Limit'); ?></th>
                                    <th><?php echo app('translator')->get('Transfer Charge'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <?php if(can('admin.bank.edit') || can('admin.bank.change.status')): ?>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($loop->index + $banks->firstItem()); ?></td>

                                        <td>
                                            <span class="text--primary fw-bold"><?php echo e(__($bank->name)); ?></span>
                                            <br>
                                            <span><?php echo app('translator')->get('Processing Time'); ?>: <?php echo e($bank->processing_time); ?></span>
                                        </td>

                                        <td>
                                            <span class="fw-bold"><?php echo app('translator')->get('Min'); ?>:</span>
                                            <?php echo e($general->cur_sym . showAmount($bank->minimum_limit)); ?>

                                            <br>
                                            <span class="fw-bold"><?php echo app('translator')->get('Max'); ?>:</span>
                                            <?php echo e($general->cur_sym . showAmount($bank->maximum_limit)); ?>

                                        </td>

                                        <td>
                                            <span class="fw-bold"><?php echo app('translator')->get('Fixed'); ?>:</span> <?php echo e($general->cur_sym . showAmount($bank->fixed_charge)); ?>

                                            <br>
                                            <span class="fw-bold"><?php echo app('translator')->get('Percent'); ?>:</span> <?php echo e(getAmount($bank->percent_charge)); ?>%
                                        </td>

                                        <td><?php echo $bank->statusBadge;?></td>
                                        <?php if(can('admin.bank.edit') || can('admin.bank.change.status')): ?>
                                            <td>
                                                <div class="button--group">
                                                    <?php $hasPermission = App\Models\Role::hasPermission('admin.bank.edit')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                                        <a class="btn btn-sm btn-outline--primary" href="<?php echo e(route('admin.bank.edit', $bank->id)); ?>">
                                                            <i class="la la-pencil"></i> <?php echo app('translator')->get('Edit'); ?>
                                                        </a>
                                                    <?php endif ?>

                                                    <?php $hasPermission = App\Models\Role::hasPermission('admin.bank.change.status')  ? 1 : 0;
            if($hasPermission == 1): ?>
                                                        <?php if(!$bank->status): ?>
                                                            <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to enable this bank?'); ?>" data-action="<?php echo e(route('admin.bank.change.status', $bank->id)); ?>"><i class="la la-eye"></i> <?php echo app('translator')->get('Enable'); ?></button>
                                                        <?php else: ?>
                                                            <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to disable this bank?'); ?>" data-action="<?php echo e(route('admin.bank.change.status', $bank->id)); ?>"> <i class="la la-eye-slash"></i> <?php echo app('translator')->get('Disable'); ?></button>
                                                        <?php endif; ?>
                                                    <?php endif ?>
                                                </div>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($banks->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($banks)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php $hasPermission = App\Models\Role::hasPermission('admin.bank.change.status')  ? 1 : 0;
            if($hasPermission == 1): ?>
        <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
    <?php endif ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Bank Name']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Bank Name']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <?php $hasPermission = App\Models\Role::hasPermission('admin.bank.create')  ? 1 : 0;
            if($hasPermission == 1): ?>
        <a class="btn btn-outline--primary" href="<?php echo e(route('admin.bank.create')); ?>">
            <i class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?>
        </a>
    <?php endif ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sorrowbank\core\resources\views/admin/other_banks/index.blade.php ENDPATH**/ ?>