<?php $__env->startSection('content'); ?>
    <div class="container">

        <div class="d-flex flex-wrap justify-content-end align-content-center mb-4 gap-2">
            <a class="btn h-45 btn--base" href="<?php echo e(route('user.deposit.index')); ?>">
                <i class="las la-plus"></i>
                <?php echo app('translator')->get('Deposit Now'); ?>
            </a>
            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'TRX No.','btn' => 'btn--base']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'TRX No.','btn' => 'btn--base']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
        </div>

        <div class="table-responsive--md">
            <table class="custom--table table">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('S.N.'); ?></th>
                        <th><?php echo app('translator')->get('Gateway'); ?> | <?php echo app('translator')->get('TRX No.'); ?></th>
                        <th><?php echo app('translator')->get('Initiated'); ?></th>
                        <th><?php echo app('translator')->get('Amount'); ?></th>
                        <th><?php echo app('translator')->get('Conversion'); ?></th>
                        <th><?php echo app('translator')->get('Status'); ?></th>
                        <th><?php echo app('translator')->get('Details'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($loop->index + $deposits->firstItem()); ?></td>

                            <td>
                                <?php if($deposit->branch): ?>
                                    <span class="fw-bold"><span class="text-primary" title="<?php echo app('translator')->get('Branch Name'); ?>">
                                            <?php echo e(__(@$deposit->branch->name)); ?></span>
                                    <?php else: ?>
                                        <span class="fw-bold"><span class="text-primary" title="<?php echo app('translator')->get('Gateway Name'); ?>">
                                                <?php echo e(__(@$deposit->gateway->name)); ?></span>
                                <?php endif; ?>
                                <br>
                                <small> <?php echo e($deposit->trx); ?> </small>
                            </td>

                            <td>
                                <em>
                                    <?php echo e(showDateTime($deposit->created_at)); ?>

                                    <br>
                                    <?php echo e(diffForHumans($deposit->created_at)); ?>

                                </em>
                            </td>

                            <td>
                                <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($deposit->amount)); ?> + <span class="text-danger"
                                    title="<?php echo app('translator')->get('charge'); ?>"><?php echo e(showAmount($deposit->charge)); ?> </span>
                                <br>
                                <strong title="<?php echo app('translator')->get('Amount with charge'); ?>">
                                    <?php echo e(showAmount($deposit->amount + $deposit->charge)); ?> <?php echo e(__($general->cur_text)); ?>

                                </strong>
                            </td>

                            <td>
                                1 <?php echo e(__($general->cur_text)); ?> = <?php echo e(showAmount($deposit->rate)); ?>

                                <?php echo e(__($deposit->method_currency)); ?>

                                <br>
                                <strong><?php echo e(showAmount($deposit->final_amo)); ?>

                                    <?php echo e(__($deposit->method_currency)); ?></strong>
                            </td>

                            <td> <?php echo $deposit->statusBadge ?></td>

                            <?php
                                $details = $deposit->detail != null ? json_encode($deposit->detail) : null;
                            ?>

                            <td>
                                <div class="btn--group">
                                    <button
                                        class="btn btn-outline--base btn-sm <?php if($deposit->method_code >= 1000): ?> detailBtn <?php else: ?> disabled <?php endif; ?>"
                                        type="button"
                                        <?php if($deposit->method_code >= 1000): ?> data-info="<?php echo e($details); ?>" <?php endif; ?>
                                        <?php if($deposit->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($deposit->admin_feedback); ?>" <?php endif; ?>>
                                        <i class="la la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($deposits->hasPages()): ?>
            <div class="mt-3">
                <?php echo e($deposits->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var userData = $(this).data('info');
                var html = '';

                if (userData) {
                    userData.forEach(element => {
                        if (element.type != 'file') {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span">${element.value}</span>
                            </li>`;
                        }
                    });
                }
                modal.find('.userData').html(html);
                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }
                modal.find('.feedback').html(adminFeedback);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .c-p {
            padding: 12px !important;
        }

        .button--group {
            display: flex;
            flex-wrap: wrap;
            justify-content: end;
            gap: 3px;
            flex-grow: 1;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('modal'); ?>
    <div class="modal fade" id="detailModal" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body p-0">
                    <ul class="list-group list-group-flush userData mb-2">
                    </ul>
                    <div class="feedback"></div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-dark btn-sm" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/user/deposit_history.blade.php ENDPATH**/ ?>