<?php $__env->startSection('content'); ?>
    <div class="container pt-80 pb-80">
        <div class="row justify-content-center">
            <div class="col-lg-7">
                <div class="card custom--card">
                    <div class="card-body">
                        <div class="alert alert-warning" role="alert">
                            <strong> <i class="la la-info-circle"></i> <?php echo app('translator')->get('You need to complete your profile to get access to your dashboard'); ?></strong>
                        </div>
                        <form method="POST" action="<?php echo e(route('user.data.submit')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">

                                <div class="form-group col-sm-6">
                                    <label class="form-label required"><?php echo app('translator')->get('First Name'); ?></label>
                                    <input type="text" class="form--control" name="firstname" value="<?php echo e(old('firstname')); ?>" required>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label required"><?php echo app('translator')->get('Last Name'); ?></label>
                                    <input type="text" class="form--control" name="lastname" value="<?php echo e(old('lastname')); ?>" required>
                                </div>

                                <div class="form-group col-12">
                                    <label class="form-label required"><?php echo app('translator')->get('Image'); ?></label>
                                    <input type="file" class="form--control" name="image" id="imageUpload" value="<?php echo e(old('firstname')); ?>" accept=".png, .jpg, .jpeg" required>
                                    <div class="proifle-image-preview d-none"><img src="" alt="profile-image"></div>
                                </div>

                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Address'); ?></label>
                                    <input type="text" class="form--control" name="address" value="<?php echo e(old('address')); ?>">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('State'); ?></label>
                                    <input type="text" class="form--control" name="state" value="<?php echo e(old('state')); ?>">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('Zip Code'); ?></label>
                                    <input type="text" class="form--control" name="zip" value="<?php echo e(old('zip')); ?>">
                                </div>

                                <div class="form-group col-sm-6">
                                    <label class="form-label"><?php echo app('translator')->get('City'); ?></label>
                                    <input type="text" class="form--control" name="city" value="<?php echo e(old('city')); ?>">
                                </div>
                            </div>

                            <button type="submit" class="btn btn-md btn--base w-100">
                                <?php echo app('translator')->get('Submit'); ?>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .proifle-image-preview {
            margin-top: 15px;
        }

        .proifle-image-preview img {
            width: 200px;
            height: 160px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $("#imageUpload").on('change', function() {
            if (this.files && this.files[0]) {
                let reader = new FileReader();
                reader.onload = function(e) {
                    $('.proifle-image-preview').removeClass('d-none');
                    $('.proifle-image-preview img').attr('src', e.target.result)
                }
                reader.readAsDataURL(this.files[0]);
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/user/user_data.blade.php ENDPATH**/ ?>