<?php $__env->startSection('panel'); ?>
    <form action="" method="POST">
        <?php echo csrf_field(); ?>
        <div class="card">
            <div class="card-header">
                <h6 class="card-title text-center"><?php echo app('translator')->get('Basic Configuration'); ?></h6>
            </div>

            <div class="card-body has-select2">
                <div class="row">
                    <div class="col-md-4 col-sm-6">
                        <div class="form-group">
                            <label> <?php echo app('translator')->get('Site Title'); ?></label>
                            <input class="form-control" name="site_name" type="text" value="<?php echo e($general->site_name); ?>" required>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-6">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Currency'); ?></label>
                            <input class="form-control" name="cur_text" type="text" value="<?php echo e($general->cur_text); ?>" required>
                        </div>
                    </div>

                    <div class="col-md-4 col-sm-6">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Currency Symbol'); ?></label>
                            <input class="form-control" name="cur_sym" type="text" value="<?php echo e($general->cur_sym); ?>" required>
                        </div>
                    </div>

                    <div class="form-group col-md-4 col-sm-6">
                        <label> <?php echo app('translator')->get('Timezone'); ?></label>
                        <select class="select2-basic" name="timezone">
                            <?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="'<?php echo e(@$timezone); ?>'"><?php echo e(__($timezone)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group col-md-4 col-sm-6">
                        <label> <?php echo app('translator')->get('Base Color'); ?></label>
                        <div class="input-group">
                            <span class="input-group-text border-0 p-0">
                                <input class="form-control colorPicker" type='text' value="<?php echo e($general->base_color); ?>" />
                            </span>
                            <input class="form-control colorCode" name="base_color" type="text" value="<?php echo e($general->base_color); ?>" />
                        </div>
                    </div>

                    <div class="form-group col-md-4 col-sm-6">
                        <label> <?php echo app('translator')->get('Secondary Color'); ?></label>
                        <div class="input-group">
                            <span class="input-group-text border-0 p-0">
                                <input class="form-control colorPicker" type='text' value="<?php echo e($general->secondary_color); ?>" />
                            </span>
                            <input class="form-control colorCode" name="secondary_color" type="text" value="<?php echo e($general->secondary_color); ?>" />
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group col-md-4 col-sm-6">
                        <label><?php echo app('translator')->get('Account Number Prefix'); ?> <i class="fa fa-info-circle text--primary" title="<?php echo app('translator')->get('This text will be added with every Account Number as a prefix.'); ?>"></i></label>
                        <input class="form-control" name="account_no_prefix" type="text" value="<?php echo e($general->account_no_prefix); ?>">
                    </div>

                    <div class="form-group col-md-4 col-sm-6">
                        <label><?php echo app('translator')->get('Account Number Length'); ?> <i class="fa fa-info-circle text--primary" title="<?php echo app('translator')->get('The number of digits for an account number without the prefix.'); ?>"></i></label>
                        <input class="form-control" name="account_no_length" type="number" value="<?php echo e($general->account_no_length); ?>">
                    </div>

                    <div class="form-group col-md-4 col-sm-12">
                        <label><?php echo app('translator')->get('OTP Expiration Time'); ?> <i class="fa fa-info-circle text--primary" title="<?php echo app('translator')->get('How long an OTP is valid. The Users need to verify the OTP code for any money-out transaction from this system if the OTP module is enabled.'); ?>"></i></label>
                        <div class="input-group">
                            <input class="form-control" name="otp_time" type="number" value="<?php echo e(getAmount($general->otp_time)); ?>">
                            <span class="input-group-text"> <?php echo app('translator')->get('Seconds'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title text-center"><?php echo app('translator')->get('Transfer Limits within'); ?> <?php echo e(__($general->site_name)); ?></h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-sm-6 col-md-4">
                        <label>
                            <?php echo app('translator')->get('Minimum Limit'); ?> <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('For each Money Transfer within ' . $general->site_name . ', Users can\'t transfer money less than the Minimum Transfer Limit.'); ?>"></i>
                        </label>
                        <div class="input-group">
                            <input class="form-control" name="minimum_transfer_limit" type="number" value="<?php echo e(getAmount($general->minimum_transfer_limit)); ?>" step="any">
                            <span class="input-group-text curency-text"><?php echo app('translator')->get($general->cur_text); ?></span>
                        </div>
                    </div>

                    <div class="form-group col-sm-6 col-md-4">
                        <label>
                            <?php echo app('translator')->get('Daily Limit'); ?>
                            <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The maximum amount that can be transferred on a particular date.'); ?>"></i>
                        </label>
                        <div class="input-group">
                            <input class="form-control" name="daily_transfer_limit" type="number" value="<?php echo e(getAmount($general->daily_transfer_limit)); ?>" step="any">
                            <span class="input-group-text curency-text"><?php echo app('translator')->get($general->cur_text); ?></span>
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-md-4">
                        <label>
                            <?php echo app('translator')->get('Monthly Limit'); ?>
                            <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The maximum amount that can be transferred on a particular month.'); ?>"></i>
                        </label>
                        <div class="input-group">
                            <input class="form-control" name="monthly_transfer_limit" type="number" value="<?php echo e(getAmount($general->monthly_transfer_limit)); ?>" step="any">
                            <span class="input-group-text curency-text"><?php echo app('translator')->get($general->cur_text); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h6 class="card-title text-center"><?php echo app('translator')->get('Transfer Charges within'); ?> <?php echo e(__($general->site_name)); ?></h6>
            </div>

            <div class="card-body">
                <div class="row">
                    <div class="form-group col-sm-6">
                        <label><?php echo app('translator')->get('Fixed Charge'); ?></label>
                        <div class="input-group">
                            <input class="form-control" name="fixed_transfer_charge" type="number" value="<?php echo e(getAmount($general->fixed_transfer_charge)); ?>" step="any">
                            <span class="input-group-text curency-text"><?php echo app('translator')->get($general->cur_text); ?> </span>
                        </div>
                    </div>

                    <div class="form-group col-sm-6">
                        <label><?php echo app('translator')->get('Percent Charge'); ?></label>
                        <div class="input-group">
                            <input class="form-control" name="percent_transfer_charge" type="number" value="<?php echo e(getAmount($general->percent_transfer_charge)); ?>" step="any">
                            <span class="input-group-text curency-text">%</span>
                        </div>
                    </div>
                </div>

                <small>
                    <i class="la la-info-circle text--primary"></i>
                    <i class="text-muted"><?php echo app('translator')->get('Fixed + Percent charge amount will be applied on each transfer within'); ?> <?php echo e(__($general->site_name)); ?></i>
                </small>
            </div>
        </div>
        <?php $hasPermission = App\Models\Role::hasPermission('admin.setting.update')  ? 1 : 0;
            if($hasPermission == 1): ?>
            <button class="btn btn--primary w-100 h-45 mt-3" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
        <?php endif ?>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .select2-container {
            z-index: 0 !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset('assets/admin/css/spectrum.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/spectrum.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.colorPicker').spectrum({
                color: $(this).data('color'),
                change: function(color) {
                    $(this).parent().siblings('.colorCode').val(color.toHexString().replace(/^#?/, ''));
                }
            });

            $('.colorCode').on('input', function() {
                var clr = $(this).val();
                $(this).parents('.input-group').find('.colorPicker').spectrum({
                    color: clr,
                });
            });

            $('select[name=timezone]').val("'<?php echo e(config('app.timezone')); ?>'").select2();
            $('.select2-basic').select2({
                dropdownParent: $('.card-body.has-select2')
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\sorrowbank\core\resources\views/admin/setting/general.blade.php ENDPATH**/ ?>