<?php $__env->startSection('content'); ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10">
                <div class="text-end mb-3">
                    <a href="<?php echo e(route('ticket.index')); ?>" class="btn btn-sm btn--base mb-2"><i class="la la-list"></i> <?php echo app('translator')->get('All Tickets'); ?></a>
                </div>
                <div class="card custom--card">
                    <div class="card-body">
                        <form action="<?php echo e(route('ticket.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label class="form-label"><?php echo app('translator')->get('Subject'); ?></label>
                                    <input type="text" name="subject" value="<?php echo e(old('subject')); ?>" class="form--control" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class="form-label"><?php echo app('translator')->get('Priority'); ?></label>
                                    <select name="priority" class="form--control" required>
                                        <option value="3"><?php echo app('translator')->get('High'); ?></option>
                                        <option value="2"><?php echo app('translator')->get('Medium'); ?></option>
                                        <option value="1"><?php echo app('translator')->get('Low'); ?></option>
                                    </select>
                                </div>
                                <div class="col-12 form-group">
                                    <label class="form-label"><?php echo app('translator')->get('Message'); ?></label>
                                    <textarea name="message" id="inputMessage" rows="6" class="form--control" required><?php echo e(old('message')); ?></textarea>
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="text-end">
                                    <button type="button" class="btn btn--base btn-sm addFile">
                                        <i class="fa fa-plus"></i> <?php echo app('translator')->get('Add New'); ?>
                                    </button>
                                </div>
                                <div class="file-upload">
                                    <label class="form-label fw-bold"><?php echo app('translator')->get('Attachments'); ?></label> <small class="text-danger"><?php echo app('translator')->get('Max 5 files can be uploaded'); ?>. <?php echo app('translator')->get('Maximum upload size is'); ?> <?php echo e(ini_get('upload_max_filesize')); ?></small>
                                    <input type="file" name="attachments[]" id="inputAttachments" class="form--control mb-2" />
                                    <div id="fileUploadsContainer"></div>
                                    <p class="ticket-attachments-message text-muted">
                                        <?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>, .<?php echo app('translator')->get('jpeg'); ?>, .<?php echo app('translator')->get('png'); ?>, .<?php echo app('translator')->get('pdf'); ?>, .<?php echo app('translator')->get('doc'); ?>, .<?php echo app('translator')->get('docx'); ?>
                                    </p>
                                </div>

                            </div>

                            <button class="btn btn--base w-100" type="submit"><i class="fa fa-paper-plane"></i>&nbsp;<?php echo app('translator')->get('Submit'); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .input-group-text:focus {
            box-shadow: none !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            var fileAdded = 0;
            $('.addFile').on('click', function() {
                if (fileAdded >= 4) {
                    notify('error', 'You\'ve added maximum number of file');
                    return false;
                }
                fileAdded++;
                $("#fileUploadsContainer").append(`
                    <div class="input-group my-3">
                        <input type="file" name="attachments[]" class="form--control" required />
                        <button type="button" class="input-group-text btn-danger remove-btn"><i class="las la-times"></i></button>
                    </div>
                `)
            });
            $(document).on('click', '.remove-btn', function() {
                fileAdded--;
                $(this).closest('.input-group').remove();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('bottom-menu'); ?>
    <li><a href="<?php echo e(route('user.profile.setting')); ?>"><?php echo app('translator')->get('Profile'); ?></a></li>
    <li><a href="<?php echo e(route('user.twofactor')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a></li>
    <li><a href="<?php echo e(route('user.change.password')); ?>"><?php echo app('translator')->get('Change Password'); ?></a></li>
    <li><a href="<?php echo e(route('user.transaction.history')); ?>"><?php echo app('translator')->get('Transactions'); ?></a></li>
    <li><a class="active" href="<?php echo e(route('ticket.index')); ?>"><?php echo app('translator')->get('Support Tickets'); ?></a></li>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/user/support/create.blade.php ENDPATH**/ ?>