<div class="row justify-content-center gy-4 gx-sm-2 gx-md-4">
    <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col-lg-4 col-sm-6">
            <div class="plan-card rounded-3 wow fadeInUp">
                <div class="plan-card__header">
                    <div class="wave-shape">
                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/elements/wave.png')); ?>" alt="img">
                    </div>
                    <h4 class="plan-name"><?php echo e(__($plan->name)); ?></h4>
                    <div class="plan-price">
                        <?php echo e(getAmount($plan->per_installment)); ?>% <sub>/<?php echo e($plan->installment_interval); ?> <?php echo app('translator')->get('Days'); ?></sub>
                    </div>
                </div>

                <div class="plan-card__body text-center">
                    <ul class="plan-feature-list">
                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Take Minimum'); ?></span>
                            <?php echo e(__($general->cur_sym)); ?><?php echo e(__(showAmount($plan->minimum_amount))); ?>

                        </li>

                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Take Maximum'); ?></span>
                            <?php echo e(__($general->cur_sym)); ?><?php echo e(__(showAmount($plan->maximum_amount))); ?>

                        </li>

                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Per Installment'); ?></span>
                            <?php echo e(__(getAmount($plan->per_installment))); ?>%
                        </li>

                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Installment Interval'); ?></span>
                            <?php echo e(__($plan->installment_interval)); ?> <?php echo app('translator')->get('Days'); ?>
                        </li>

                        <li class="d-flex flex-wrap justify-content-between">
                            <span> <?php echo app('translator')->get('Total Installment'); ?></span>
                            <?php echo e(__($plan->total_installment)); ?>

                        </li>
                    </ul>
                </div>

                <div class="plan-card__footer text-center">
                    <button type="button" data-id="<?php echo e($plan->id); ?>" data-minimum="<?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->minimum_amount)); ?>" data-maximum="<?php echo e($general->cur_sym); ?><?php echo e(showAmount($plan->maximum_amount)); ?>" class="btn btn-md w-100 btn--base loanBtn"><?php echo app('translator')->get('Apply Now'); ?>
                    </button>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.loanBtn').on('click', (e) => {
                var modal = $('#loanModal');
                let data = e.currentTarget.dataset;
                modal.find('.min-limit').text(`Minimum Amount ${data.minimum}`);
                modal.find('.max-limit').text(`Maximum Amount ${data.maximum}`);
                let form = modal.find('form')[0];
                form.action = `<?php echo e(route('user.loan.apply', '')); ?>/${data.id}`;
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('modal'); ?>
    <div class="modal fade" id="loanModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="" method="post">
                    <?php if(auth()->guard()->check()): ?>
                        <div class="modal-header">
                            <h5 class="modal-title method-name" id="exampleModalLabel"><?php echo app('translator')->get('Apply for Loan'); ?></h5>
                            <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <i class="las la-times"></i>
                            </span>
                        </div>

                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="" class="required"><?php echo app('translator')->get('Amount'); ?></label>
                                <div class="input-group">
                                    <input type="number" step="any" name="amount" class="form--control" placeholder="<?php echo app('translator')->get('Enter An Amount'); ?>" required>
                                    <span class="input-group-text"> <?php echo e($general->cur_text); ?> </span>
                                </div>
                                <p><small class="text--danger min-limit"></small></p>
                                <p><small class="text-danger max-limit"></small></p>
                            </div>
                            <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Confirm'); ?></button>
                        </div>
                    <?php else: ?>
                        <div class="modal-body">
                            <div class="text-center"><i class="la la-times-circle text--danger la-6x" aria-hidden="true"></i></div>
                            <h3 class="text-center mt-3"><?php echo app('translator')->get('You are not logged in!'); ?></h3>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-sm btn--dark" data-bs-dismiss="modal" aria-label="Close"><?php echo app('translator')->get('Close'); ?></button>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/partials/loan_plans.blade.php ENDPATH**/ ?>