<?php $__env->startSection('content'); ?>
    <div class="container">

        <div class="user-profile-wrapper">
            <div class="profile-info">
                <div class="card custom--card">
                    <div class="card-body">
                        <div class="proifle-image-preview">
                            <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . $user->image, null, true)); ?>" alt="profile-image">
                        </div>

                        <ul class="caption-list-two mt-4">
                            <li>
                                <span class="caption"><?php echo app('translator')->get('Account No.'); ?></span>
                                <span class="value"><?php echo e($user->account_number); ?></span>
                            </li>

                            <?php if($user->branch): ?>
                                <li>
                                    <span class="caption"><?php echo app('translator')->get('Branch'); ?></span>
                                    <span class="value"><?php echo e($user->branch->name); ?></span>
                                </li>
                            <?php endif; ?>

                            <li>
                                <span class="caption"><?php echo app('translator')->get('Username'); ?></span>
                                <span class="value"><?php echo e($user->username); ?></span>
                            </li>

                            <li>
                                <span class="caption"><?php echo app('translator')->get('Email'); ?></span>
                                <span class="value"><?php echo e($user->email); ?></span>
                            </li>

                            <li>
                                <span class="caption"><?php echo app('translator')->get('Mobile'); ?></span>
                                <span class="value">+<?php echo e($user->mobile); ?></span>
                            </li>

                            <li>
                                <span class="caption"><?php echo app('translator')->get('Country'); ?></span>
                                <span class="value"><?php echo e($user->address->country); ?></span>
                            </li>

                        </ul>
                    </div>
                </div>
            </div>

            <div class="profile-form">
                <div class="card custom--card">

                    <div class="card-body">
                        <form class="register" action="" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row">

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('First Name'); ?></label>
                                        <input class="form--control" name="firstname" type="text" value="<?php echo e($user->firstname); ?>" required>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Last Name'); ?></label>
                                        <input class="form--control" name="lastname" type="text" value="<?php echo e($user->lastname); ?>" required>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('State'); ?></label>
                                        <input class="form--control" name="state" type="text" value="<?php echo e(@$user->address->state); ?>">
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('City'); ?></label>
                                        <input class="form--control" name="city" type="text" value="<?php echo e(@$user->address->city); ?>">
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Zip Code'); ?></label>
                                        <input class="form--control" name="zip" type="text" value="<?php echo e(@$user->address->zip); ?>">
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="form-label"><?php echo app('translator')->get('Address'); ?></label>
                                        <input class="form--control" name="address" type="text" value="<?php echo e(@$user->address->address); ?>">
                                    </div>
                                </div>

                                <div class="col">
                                    <div class="form-group">
                                        <label><?php echo app('translator')->get('Image'); ?></label>
                                        <input class="form--control" id="imageUpload" name="image" type='file' accept=".png, .jpg, .jpeg" />
                                    </div>
                                </div>

                            </div>
                            <button class="btn btn-md btn--base w-100" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .user-profile-wrapper {
            display: flex;
            justify-content: center;
            gap: 15px;
            flex-wrap: wrap;
        }

        .profile-info {
            width: 320px;
        }

        .profile-form {
            width: calc(100% - 335px);
        }

        @media(max-width:767px) {
            .user-profile-wrapper {
                gap: 10px;
            }

            .profile-info {
                width: 380px;
            }

            .profile-form {
                width: 380px;
            }
        }

        @media(max-width:590px) {
            .profile-info {
                width: 300px;
            }

            .profile-form {
                width: 300px;
            }
        }

        .proifle-image-preview {
            text-align: center;
        }

        .proifle-image-preview img {
            width: 100%;
            height: auto;
            max-height: 300px;
            border-radius: 5px;
        }

        .caption-list-two {
            padding: 0;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        $("#imageUpload").on('change', function() {
            if (this.files && this.files[0]) {
                let reader = new FileReader();
                reader.onload = function(e) {
                    $('.proifle-image-preview img').attr('src', e.target.result)
                }
                reader.readAsDataURL(this.files[0]);
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('bottom-menu'); ?>
    <li>
        <a class="active" href="<?php echo e(route('user.profile.setting')); ?>"><?php echo app('translator')->get('Profile'); ?></a>
    </li>

    <?php if($general->modules->referral_system): ?>
        <li><a href="<?php echo e(route('user.referral.users')); ?>"><?php echo app('translator')->get('Referral'); ?></a></li>
    <?php endif; ?>

    <li><a href="<?php echo e(route('user.twofactor')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a></li>
    <li><a href="<?php echo e(route('user.change.password')); ?>"><?php echo app('translator')->get('Change Password'); ?></a></li>
    <li><a href="<?php echo e(route('user.transaction.history')); ?>"><?php echo app('translator')->get('Transactions'); ?></a></li>
    <li><a class="<?php echo e(menuActive(['ticket.*'])); ?>" href="<?php echo e(route('ticket.index')); ?>"><?php echo app('translator')->get('Support Tickets'); ?></a></li>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/user/profile_setting.blade.php ENDPATH**/ ?>