<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <form action="<?php echo e(route('admin.bank.store', $bank->id ?? 0)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row gy-4">
                    <div class="col-12">
                        <div class="card b-radius--10">
                            <div class="card-body">
                                <div class="row gy-3">
                                    <div class="col-md-6">
                                        <div class="form-group mb-0">
                                            <label><?php echo app('translator')->get('Bank Name'); ?></label>
                                            <input class="form-control" name="name" type="text" value="<?php echo e(old('name', @$bank->name)); ?>" required />
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group mb-0">
                                            <label><?php echo app('translator')->get('Processing Time'); ?> </label>
                                            <div class="input-group">
                                                <input class="form-control" name="processing_time" type="text" value="<?php echo e(old('processing_time', @$bank->processing_time)); ?>" required />
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title"><?php echo app('translator')->get('Transfer Limit'); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Minimum Amount'); ?></label>
                                    <div class="input-group">
                                        <?php $value = isset($bank) ? getAmount($bank->minimum_limit) : null; ?>
                                        <input class="form-control" name="minimum_amount" type="number" value="<?php echo e(old('minimum_amount', $value)); ?>" step="any" required />
                                        <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Amount'); ?></label>
                                    <div class="input-group">
                                        <?php $value = isset($bank) ? getAmount($bank->maximum_limit) : null; ?>
                                        <input class="form-control" name="maximum_amount" type="number" value="<?php echo e(old('maximum_amount', $value)); ?>" step="any" required />
                                        <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title"><?php echo app('translator')->get('Transfer Charge'); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Fixed Charge'); ?></label>
                                    <div class="input-group">
                                        <?php $value = isset($bank) ? getAmount($bank->fixed_charge) : null; ?>
                                        <input class="form-control" name="fixed_charge" type="number" value="<?php echo e(old('fixed_charge', $value)); ?>" step="any" required />

                                        <span class="input-group-text"><?php echo e(__($general->cur_text)); ?></span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Percent Charge'); ?></label>
                                    <div class="input-group">
                                        <?php $value = isset($bank) ? getAmount($bank->percent_charge) : null; ?>
                                        <input class="form-control" name="percent_charge" type="number" value="<?php echo e(old('percent_charge', $value)); ?>" step="any" required />

                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title"><?php echo app('translator')->get('Daily Limit'); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Transaction Amount'); ?></label>
                                    <div class="input-group">
                                        <?php $value = isset($bank) ? getAmount($bank->daily_maximum_limit) : null; ?>
                                        <input class="form-control" name="daily_maximum_amount" type="number" value="<?php echo e(old('daily_maximum_amount', $value)); ?>" step="any" required />
                                        <span class="input-group-text"> <?php echo e(__($general->cur_text)); ?> </span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="daily_transaction_count"><?php echo app('translator')->get('Maximum Transaction Count'); ?></label>
                                    <?php $value = isset($bank) ? getAmount($bank->daily_total_transaction) : null; ?>
                                    <input class="form-control" name="daily_transaction_count" type="number" value="<?php echo e(old('daily_transaction_count', $value)); ?>" required />
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title"><?php echo app('translator')->get('Monthly Limit'); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Transaction Amount'); ?></label>
                                    <div class="input-group">
                                        <?php $value = isset($bank) ? getAmount($bank->monthly_maximum_limit) : null; ?>

                                        <input class="form-control" name="monthly_maximum_amount" type="number" value="<?php echo e(old('monthly_maximum_amount', $value)); ?>" step="any" required />
                                        <span class="input-group-text"> <?php echo e(__($general->cur_text)); ?> </span>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Transaction Count'); ?></label>
                                    <?php $value = isset($bank) ? getAmount($bank->monthly_total_transaction) : null; ?>
                                    <input class="form-control" name="monthly_transaction_count" type="number" value="<?php echo e(old('monthly_transaction_count', $value)); ?>" required />
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title"><?php echo app('translator')->get('Instruction to Transfer'); ?> <i class="fa fa-info-circle text--primary" title="<?php echo app('translator')->get('Users will see this instruction while he/she transferring money to this bank.'); ?>"></i></h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <textarea class="form-control nicEdit" name="instruction" rows="8"><?php echo old('instruction', @$bank->instruction) ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.viser-form-data','data' => ['form' => @$form]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('viser-form-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['form' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(@$form)]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php $hasPermission = App\Models\Role::hasPermission('admin.bank.store')  ? 1 : 0;
            if($hasPermission == 1): ?>
                    <button class="btn btn--primary w-100 h-45 mt-3" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                <?php endif ?>
            </form>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalc2e85c5a6f46a6358a3b68e5bf9789587ca94cfe = $component; } ?>
<?php $component = App\View\Components\FormGenerator::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form-generator'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\FormGenerator::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc2e85c5a6f46a6358a3b68e5bf9789587ca94cfe)): ?>
<?php $component = $__componentOriginalc2e85c5a6f46a6358a3b68e5bf9789587ca94cfe; ?>
<?php unset($__componentOriginalc2e85c5a6f46a6358a3b68e5bf9789587ca94cfe); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $hasPermission = App\Models\Role::hasPermission('admin.bank.index')  ? 1 : 0;
            if($hasPermission == 1): ?>
    <?php $__env->startPush('breadcrumb-plugins'); ?>
        <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.back','data' => ['route' => ''.e(route('admin.bank.index')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['route' => ''.e(route('admin.bank.index')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
    <?php $__env->stopPush(); ?>
<?php endif ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/admin/other_banks/form.blade.php ENDPATH**/ ?>