<?php if($general->modules->loan): ?>
    <?php
        $content = getContent('loan_plans.content', true);
        $plans = App\Models\LoanPlan::active()
            ->latest()
            ->limit(3)
            ->get();
    ?>
    <?php if($content && $plans->count()): ?>
        <section class="pt-80 pb-80">
            <div class="container-md">
                <div class="row justify-content-center">
                    <div class="col-xl-5 col-lg-7">
                        <div class="section-header text-center">
                            <div class="section-top-title border-left custom--cl"><?php echo e(__(@$content->data_values->title)); ?></div>
                            <h2 class="section-title"><?php echo e(__(@$content->data_values->heading)); ?></h2>
                        </div>
                    </div>
                </div>
                <?php echo $__env->make($activeTemplate . 'partials.loan_plans', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="text-center mt-4">
                    <a href="<?php echo e(route('user.loan.plans')); ?>" class="btn btn--base"><?php echo app('translator')->get('View All'); ?></a>
                </div>
            </div>
        </section>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\viserbank\core\resources\views/templates/basic/sections/loan_plans.blade.php ENDPATH**/ ?>